unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMMemMap, MMObj, MMGauge, MMWave, MMDSPObj, MMMPEG, StdCtrls, MMRegs,
  MMSystem, MMMPType, MMACMDlg, MMUtils;

type
  TForm1 = class(TForm)
    btnConvert: TButton;
    MPEGFile: TMMMPEGFile;
    WaveFile: TMMWaveFile;
    Gauge: TMMGauge;
    OpenDialog: TOpenDialog;
    MemMapFile: TMMMemMapFile;
    procedure btnConvertClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
{-------------------------------------------------------}
procedure TForm1.btnConvertClick(Sender: TObject);
var
   pwfx: PWaveFormatEx;
   nChannels: integer;
   nBytes,nWrite,n: Longint;
begin
   if OpenDialog.Execute then
   begin
      MpegFile.FileName := OpenDialog.FileName;

      if (MpegFile.Layer = 2) or (MpegFile.Layer = 3) then
      with Mpegfile do
      begin
         if ((Mode <> smSingleChannel) and (ChannelMode = cmBoth)) then
            nChannels := 2
         else
            nChannels := 1;

         if (Layer = 2) then
            pwfx := Pointer(acmBuildMPEG1Header(SampleRate, Bitrate*1000, nChannels))
         else
            pwfx := Pointer(acmBuildMP3Header(SampleRate, Bitrate*1000, nChannels));

         WaveFile.Wave.CreateFile('F:\MPWAVE.WAV',pwfx);
         try
            MemMapFile.FileName := OpenDialog.FileName;
            MemMapFile.OpenFile;
            try
               nBytes := MemMapFile.FileSize;
               nWrite := 0;
               Gauge.MaxValue := nBytes;
               while (nBytes > 0) do
               begin
                  n := 32768;
                  if n > nBytes then
                     n := nBytes;

                  WaveFile.Wave.WriteDataBytes(PChar(MemMapFile.FileData)+nWrite,n);
                  inc(nWrite,n);
                  dec(nBytes,n);

                  Gauge.Progress := nWrite;
                  Gauge.Update;
               end;
            finally
               MemMapFile.CloseFile;
            end;
         finally
            WaveFile.Wave.CloseFile;
            GlobalFreeMem(Pointer(pwfx));
           // Gauge.Progress := 0;
         end;
      end;
   end;
end;

end.
